<?php
session_start();
include 'koneksi.php';

if (isset($_SESSION['admin'])) {
    header("location:dashboard.php");
    exit;
}

if (isset($_POST['login_btn'])) {
    $username = mysqli_real_escape_string($koneksi, $_POST['username']);
    $password = mysqli_real_escape_string($koneksi, $_POST['password']);

    // CEK KE TABEL 'USERS'
    $query = mysqli_query($koneksi, "SELECT * FROM users WHERE username='$username' AND password='$password'");
    $cek = mysqli_num_rows($query);

    if ($cek > 0) {
        $data = mysqli_fetch_assoc($query);
        
        // SET SESSION
        $_SESSION['admin']      = true;
        $_SESSION['id_user']    = $data['id'];
        $_SESSION['nama_admin'] = $data['nama_lengkap'];
        $_SESSION['role_admin'] = $data['role']; // PENTING: Ini penentu menu
        
        header("location:dashboard.php");
    } else {
        $error = "Username atau Password salah!";
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - SIM Sekolah</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <!-- Google Font: Poppins -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="logo.jpg">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: url('https://images.unsplash.com/photo-1523050854058-8df90110c9f1?q=80&w=1600&auto=format&fit=crop') no-repeat center center fixed;
            background-size: cover;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .overlay {
            position: absolute; top: 0; left: 0; width: 100%; height: 100%;
            background: rgba(13, 110, 253, 0.7);
            backdrop-filter: blur(5px);
        }
        .card-login {
            width: 100%;
            max-width: 420px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.2);
            position: relative;
            z-index: 2;
            overflow: hidden;
            border: none;
        }
        .login-header {
            text-align: center;
            padding: 40px 30px 10px;
        }
        .logo-circle {
            width: 80px; height: 80px;
            background: #0d6efd;
            color: white;
            border-radius: 50%;
            display: inline-flex;
            align-items: center; justify-content: center;
            font-size: 2.5rem;
            box-shadow: 0 5px 15px rgba(13, 110, 253, 0.3);
            margin-bottom: 15px;
        }
        .form-control:focus {
            box-shadow: none;
            border-color: #0d6efd;
        }
        .btn-login {
            background: linear-gradient(45deg, #0d6efd, #0dcaf0);
            border: none;
            padding: 12px;
            font-size: 16px;
            border-radius: 10px;
            transition: 0.3s;
        }
        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(13, 202, 240, 0.4);
        }
        .password-toggle {
            cursor: pointer;
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #6c757d;
            z-index: 10;
        }
    </style>
</head>
<body>

    <div class="overlay"></div>

    <div class="card card-login animate__animated animate__fadeInUp">
        <div class="login-header">
            <div class="logo-circle">
                <i class="bi bi-mortarboard-fill"></i>
            </div>
            <h4 class="fw-bold text-dark">SIM SEKOLAH</h4>
            <p class="text-muted small">Silahkan login</p>
        </div>
        
        <div class="card-body p-4 pt-2">
            
            <?php if(isset($error)): ?>
                <div class="alert alert-danger d-flex align-items-center" role="alert">
                    <i class="bi bi-exclamation-circle-fill me-2"></i> 
                    <div><?php echo $error; ?></div>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="form-floating mb-3">
                    <input type="text" class="form-control" id="username" name="username" placeholder="Username" required>
                    <label for="username"><i class="bi bi-person me-2"></i>Username</label>
                </div>
                
                <div class="form-floating mb-4 position-relative">
                    <input type="password" class="form-control" id="password" name="password" placeholder="Password" required>
                    <label for="password"><i class="bi bi-lock me-2"></i>Password</label>
                    <i class="bi bi-eye-slash password-toggle" id="togglePassword"></i>
                </div>

                <div class="d-grid">
                    <button type="submit" name="login_btn" class="btn btn-primary btn-login fw-bold text-white">
                        MASUK SEKARANG <i class="bi bi-arrow-right-short"></i>
                    </button>
                </div>
            </form>
        </div>
        <div class="card-footer bg-light text-center border-0 py-3">
            <small class="text-muted">&copy; 2025 IT Sekolah Indonesia</small>
        </div>
    </div>

    <script>
        const togglePassword = document.querySelector("#togglePassword");
        const password = document.querySelector("#password");

        togglePassword.addEventListener("click", function () {
            const type = password.getAttribute("type") === "password" ? "text" : "password";
            password.setAttribute("type", type);
            this.classList.toggle("bi-eye");
            this.classList.toggle("bi-eye-slash");
        });
    </script>

</body>
</html>